import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Marshaller;
import java.net.URL;
import java.io.File;

public class SampleApp9
{
   public static void main(String args[]) throws Throwable
   {
     String fileName = "sample9.xml";
     String instancePath = "customPackage";
     JAXBContext jc = JAXBContext.newInstance(instancePath);
     Unmarshaller u = jc.createUnmarshaller();
     customPackage.Business bus = 
         (customPackage.Business) u.unmarshal(fileToURL(fileName));
     System.out.println("The bussiness details are: ");
     System.out.println("    title: " + bus.getTitle());
     System.out.println("    owner: " + bus.getOwner());
     System.out.println("    id:    " + bus.getId().toString());
     System.out.println();
   }

   /**
    * This method changes the file path to URL path
    */
   private static URL fileToURL(String sfile)
   {
      File file = new File(sfile);
      String path = file.getAbsolutePath();
      String fSep = System.getProperty("file.separator");
      if (fSep != null && fSep.length() == 1)
         path = path.replace(fSep.charAt(0), '/');
      if (path.length() > 0 && path.charAt(0) != '/')
        path = '/' + path;
      try
      {
         return new URL("file" , null, path);
      }
      catch (java.net.MalformedURLException e)
      {
         throw new Error("Error: Unexpected MalformedURLException");
      }
   }

}
